<?php
include('../includes/session.php');
include('../includes/config.php');

// Check if user is admin safely
$userType = isset($udata['type']) ? $udata['type'] : ''; // default to empty string

if (!checkAdmin($userType)) {
    echo "<script>window.location='index.php';</script>";
    exit;
}

// Auto-update table schema
$columns_to_add = [
    'new_api_key' => "VARCHAR(255) DEFAULT ''",
    'new_api_url' => "VARCHAR(255) DEFAULT ''",
    'upi_id' => "VARCHAR(255) DEFAULT ''",
    'upi_merchant_code' => "VARCHAR(255) DEFAULT ''",
    'upi_secret' => "VARCHAR(255) DEFAULT ''"
];

$current_cols = [];
$res = $ahk_conn->query("SHOW COLUMNS FROM settings");
while ($row = $res->fetch_assoc()) {
    $current_cols[] = $row['Field'];
}

foreach ($columns_to_add as $col => $def) {
    if (!in_array($col, $current_cols)) {
        $ahk_conn->query("ALTER TABLE settings ADD COLUMN $col $def");
    }
}

// Populate defaults if empty (using values from new_website_api/gateway_config)
$checkEmpty = $ahk_conn->query("SELECT upi_id FROM settings WHERE id=1");
if ($checkEmpty && $checkEmpty->num_rows > 0) {
    $row = $checkEmpty->fetch_assoc();
    if (empty($row['upi_id'])) {
        $ahk_conn->query("UPDATE settings SET 
            upi_id = 'paytm.s1cwhec@pty', 
            upi_merchant_code = 'LYMaUK11988501129167', 
            upi_secret = '2667c6bd4345bf97fc9ecfb934cdb21f' 
            WHERE id = 1");
    }
}

include('../template/ahkweb/settings.php');

if(isset($_POST['webname'])){
    // General Settings
    $name = mysqli_real_escape_string($ahk_conn,$_POST['webname']);
    $phone = mysqli_real_escape_string($ahk_conn,$_POST['phone']);
    $email = mysqli_real_escape_string($ahk_conn,$_POST['email']);
    $address = mysqli_real_escape_string($ahk_conn,$_POST['address']);
    // $pgtype = mysqli_real_escape_string($ahk_conn,$_POST['pgtype']);
    $mid = mysqli_real_escape_string($ahk_conn,$_POST['mid']);
    $mkey = mysqli_real_escape_string($ahk_conn,$_POST['mkey']); 
    // $api_key = mysqli_real_escape_string($ahk_conn,$_POST['api_key']); 
    $new_api_key = mysqli_real_escape_string($ahk_conn,$_POST['new_api_key']);
    $new_api_url = mysqli_real_escape_string($ahk_conn,$_POST['new_api_url']);
    $upi_id = mysqli_real_escape_string($ahk_conn,$_POST['upi_id']); 
    $upi_merchant_code = mysqli_real_escape_string($ahk_conn,$_POST['upi_merchant_code']);
    $upi_secret = mysqli_real_escape_string($ahk_conn,$_POST['upi_secret']);
    $HomeTemplatename = mysqli_real_escape_string($ahk_conn,$_POST['HomeTemplatename']); 
    $ret_reg_fee = mysqli_real_escape_string($ahk_conn,$_POST['ret_reg_fee']); 
    $dist_reg_fee = mysqli_real_escape_string($ahk_conn,$_POST['dist_reg_fee']);
    $mobile_recharge_active = mysqli_real_escape_string($ahk_conn,$_POST['mobile_recharge_active']);

    // Payment PAYU
    $payu_mkey = mysqli_real_escape_string($ahk_conn,$_POST['payu_mkey']); 
    $salt = mysqli_real_escape_string($ahk_conn,$_POST['salt']); 

    // Payment Mode
    $paytm = mysqli_real_escape_string($ahk_conn,$_POST['paytm']);
    $payu = mysqli_real_escape_string($ahk_conn,$_POST['payu']);
    $upi = mysqli_real_escape_string($ahk_conn,$_POST['upi']);
    $qr = mysqli_real_escape_string($ahk_conn,$_POST['qr']);
    $callback_url = mysqli_real_escape_string($ahk_conn,$_POST['callback_url']);
    // $upi_key = mysqli_real_escape_string($ahk_conn,$_POST['upi_key']);

    // New fields
    $airtal = mysqli_real_escape_string($ahk_conn,$_POST['airtal']);
    $vi = mysqli_real_escape_string($ahk_conn,$_POST['vi']);
    $jio = mysqli_real_escape_string($ahk_conn,$_POST['jio']);
    $bsnl = mysqli_real_escape_string($ahk_conn,$_POST['bsnl']);
    $airtel_digital_tv_dth = mysqli_real_escape_string($ahk_conn,$_POST['airtel_digital_tv_dth']);
    $tata_sky_dth = mysqli_real_escape_string($ahk_conn,$_POST['tata_sky_dth']);
    $dishtv_dth = mysqli_real_escape_string($ahk_conn,$_POST['dishtv_dth']);
    $Videocon_dth = mysqli_real_escape_string($ahk_conn,$_POST['Videocon_dth']);
    $Sun_Direct_dth = mysqli_real_escape_string($ahk_conn,$_POST['Sun_Direct_dth']);
    $google_play = mysqli_real_escape_string($ahk_conn,$_POST['google_play']);

    // Update query
    $update = mysqli_query($ahk_conn,"UPDATE settings SET 
        webname='$name',
        phone='$phone',
        mobile_recharge_active='$mobile_recharge_active',
        email='$email',
        address='$address',
        /* pgtype='$pgtype', */
        mid='$mid',
        mkey='$mkey',
        new_api_key='$new_api_key',
        new_api_url='$new_api_url',
        callback_url='$callback_url',
        paytm='$paytm',
        payu='$payu',
        upi='$upi',
        payu_mkey='$payu_mkey',
        salt='$salt',
        /* upi_key='$upi_key', */
        qr='1',
        upi_id='$upi_id',
        upi_merchant_code='$upi_merchant_code',
        upi_secret='$upi_secret',
        /* nsdl_api_key='$api_key', */
        HomeTemplatename='$HomeTemplatename',
        ret_reg_fee='$ret_reg_fee',
        dist_reg_fee='$dist_reg_fee',
        airtal='$airtal',
        vi='$vi',
        jio='$jio',
        bsnl='$bsnl',
        airtel_digital_tv_dth='$airtel_digital_tv_dth',
        tata_sky_dth='$tata_sky_dth',
        dishtv_dth='$dishtv_dth',
        Videocon_dth='$Videocon_dth',
        Sun_Direct_dth='$Sun_Direct_dth',
        google_play='$google_play'
        WHERE id=1");

    if($update){
        ?>
        <script>
        $(function(){
            Swal.fire(
                'Settings Updated Successfully',
                '',
                'success'
            )
        });
        setTimeout(() => {
            window.location='';
        }, 1200);
        </script>
        <?php 
    } else {
        ?>
        <script>
        $(function(){
            Swal.fire(
                'Settings Not Updated',
                '<?php echo mysqli_error($ahk_conn); ?>',
                'error'
            )
        });
        </script>
        <?php
    }
}
?>
